/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.web.monitor.monitor;

import com.tp_link.eap.device.AbstractDevice;
import com.tp_link.eap.device.DeviceContext;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.bean.Location;
import com.tp_link.eap.domain.eap.bean.RssiThreshold;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.mesh.bean.MeshRelation;
import com.tp_link.eap.domain.system.OperationRecord;
import com.tp_link.eap.domain.system.UpgradeWarning;
import com.tp_link.eap.monitor.globalsetting.service.l;
import com.tp_link.eap.monitor.mesh.service.c;
import com.tp_link.eap.monitor.monitor.realtime.RealtimeStatus;
import com.tp_link.eap.monitor.monitor.service.a;
import com.tp_link.eap.monitor.monitor.service.d;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.o.b;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/monitor"})
public class ApController {
    Logger a = LoggerFactory.getLogger(ApController.class);
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b b;
    @Autowired
    private d c;
    @Autowired
    private l d;
    @Autowired
    private a e;
    @Autowired
    private com.tp_link.eap.monitor.compatibility.service.b f;
    @Autowired
    private c g;

    @RequestMapping(value={"getApLocation"}, method={RequestMethod.POST})
    @ResponseBody
    public Location getApLocation(String apId) {
        if (apId == null) {
            return null;
        }
        return this.b.getApDetail(apId).getLocation();
    }

    @RequestMapping(value={"setApRssi"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult setApRssi(RssiThreshold rssi) {
        if (rssi == null) {
            return null;
        }
        if (rssi.isEnable() && !com.tp_link.eap.util.p.c.a((int)rssi.getThreshold(), (int)-95, (int)0)) {
            return new OperationResult(false, "RSSI Threshold should be from -95 to 0.");
        }
        OperationResponse operationResponse = this.b.setRssi(rssi, false);
        return new OperationResult(operationResponse.success(), operationResponse.getMsg(), operationResponse.getResult());
    }

    @RequestMapping(value={"getForgetAllType"}, method={RequestMethod.POST})
    @ResponseBody
    public Integer getForgetAllType(@RequestParam Integer status) {
        List list = new ArrayList();
        switch (status) {
            case 0: {
                list = this.b.getSiteAdoptedAps(com.tp_link.eap.d.b.a());
                break;
            }
            case 1: {
                list = this.b.getSiteConnectedAps(com.tp_link.eap.d.b.a());
                break;
            }
            case 2: {
                list = this.b.getSiteDisconnectedAps(com.tp_link.eap.d.b.a());
                break;
            }
            case 3: {
                list = this.b.getSiteIsolatedAps(com.tp_link.eap.d.b.a());
                break;
            }
            default: {
                list = this.b.getSiteAdoptedAps(com.tp_link.eap.d.b.a());
            }
        }
        Boolean bl = false;
        Boolean bl2 = false;
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                if (ap.getStatus() == 4 || ap.getStatus() == 0) {
                    bl = true;
                }
                if (ap.getMeshConf() == null || ap.getMeshConf().getChildApMacs() == null || ap.getMeshConf().getChildApMacs().isEmpty()) continue;
                bl2 = true;
            }
        }
        Object object = 0;
        object = bl == false && bl2 == false ? Integer.valueOf(0) : (bl != false && bl2 == false ? Integer.valueOf(1) : (bl == false && bl2 != false ? Integer.valueOf(2) : Integer.valueOf(3)));
        return object;
    }

    @RequestMapping(value={"forgetAll"}, method={RequestMethod.POST})
    @ResponseBody
    public OperationResult forgetAll(@RequestParam Integer status) {
        if (status == null || status < 0 || status > 3) {
            return com.tp_link.eap.util.e.aX;
        }
        String string = com.tp_link.eap.d.b.a();
        if (OperationRecord.isFortgetDoing((String)string)) {
            return new OperationResult(false, "The Forget All operation is in progress.");
        }
        OperationRecord.refresh((String)string);
        List list = new ArrayList();
        switch (status) {
            case 1: {
                list = this.b.getSiteConnectedAps(com.tp_link.eap.d.b.a());
                break;
            }
            case 2: {
                list = this.b.getSiteDisconnectedAps(com.tp_link.eap.d.b.a());
                break;
            }
            case 3: {
                list = this.b.getSiteIsolatedAps(com.tp_link.eap.d.b.a());
                break;
            }
            default: {
                list = this.b.getSiteAdoptedAps(com.tp_link.eap.d.b.a());
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Ap ap : list) {
                arrayList.add(ap.getMac());
            }
            Map map = this.g.getApMapByHop(arrayList);
            if (!CollectionUtils.isEmpty((Map)map)) {
                for (int k = 3; k >= 0; --k) {
                    List list2 = (List)map.get(k);
                    if (CollectionUtils.isEmpty((Collection)list2)) continue;
                    HashSet<String> hashSet = new HashSet<String>();
                    for (MeshRelation meshRelation : list2) {
                        if (meshRelation.getStatus() != 1) continue;
                        hashSet.add(meshRelation.getMac());
                    }
                    this.a.debug(((Object)hashSet).toString());
                    com.tp_link.eap.util.o.b.a((Integer)0, hashSet);
                    for (MeshRelation meshRelation : list2) {
                        this.a.debug(meshRelation.getMac());
                        if (com.tp_link.eap.monitor.monitor.realtime.c.d((String)meshRelation.getMac())) {
                            bl = true;
                            continue;
                        }
                        Ap ap = this.b.getApDetail(meshRelation.getMac());
                        if (ap == null) continue;
                        this.b.forgetAp(ap.getId());
                    }
                    if (k > 0) {
                        for (int i2 = 0; com.tp_link.eap.util.o.b.c((Integer)0, hashSet) != 2 && i2 < com.tp_link.eap.c.a.f; ++i2) {
                            try {
                                Thread.sleep(com.tp_link.eap.c.a.e);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                this.a.warn(interruptedException.toString(), (Throwable)interruptedException);
                            }
                        }
                    }
                    com.tp_link.eap.util.o.b.b((Integer)0, hashSet);
                }
            }
            if (bl) {
                OperationRecord.removeForget((String)string);
                return new OperationResult(false, "Upgrading APs can not be forgot.");
            }
        } else {
            OperationRecord.removeForget((String)string);
            return new OperationResult(false, "No APs need to be forgot.");
        }
        if (status == 0 || status == 1) {
            this.b.forgetWirelessPendingSite(string);
        }
        OperationRecord.removeForget((String)string);
        return com.tp_link.eap.util.e.bc;
    }

    @RequestMapping(value={"/getPendingAps"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Ap> getPendingAps() {
        return this.b.getPendingAps();
    }

    @RequestMapping(value={"/getDeviceInfos"}, method={RequestMethod.POST})
    @ResponseBody
    public List<AbstractDevice> getDeviceInfos(String mac) {
        if (com.tp_link.eap.util.a.e.a((String)mac)) {
            return DeviceContext.getDevices();
        }
        ArrayList<AbstractDevice> arrayList = new ArrayList<AbstractDevice>();
        AbstractDevice abstractDevice = DeviceContext.getDevice((String)mac);
        arrayList.add(abstractDevice);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/existApNeedToUpgrade"})
    @ResponseBody
    public UpgradeWarning existApNeedToUpgrade() {
        boolean bl = false;
        boolean bl2 = false;
        Object object = com.tp_link.eap.b.b.a.a();
        synchronized (object) {
            List list;
            UpgradeWarning upgradeWarning = this.f.getUpgradeWarning();
            if (upgradeWarning == null) {
                bl2 = true;
                upgradeWarning = new UpgradeWarning();
            }
            if (!CollectionUtils.isEmpty((Collection)(list = this.b.getApNeedToUpgrade()))) {
                for (Ap ap : list) {
                    if (ap.getRealtimeStatus() == RealtimeStatus.c.a()) continue;
                    bl = true;
                    break;
                }
            }
            this.a.debug("exist uncompatilbe ap : " + bl);
            if (bl2) {
                this.a.debug("warning not exist, create new one.");
                upgradeWarning.setShowUpgradeIcon(bl);
                upgradeWarning.setShowUpgradeWarning(bl);
                this.f.refreshUpgradeWarning(upgradeWarning);
            } else if (bl) {
                if (!upgradeWarning.isShowUpgradeIcon() || !upgradeWarning.isShowUpgradeWarning()) {
                    upgradeWarning.setShowUpgradeIcon(true);
                    upgradeWarning.setShowUpgradeWarning(true);
                    this.f.refreshUpgradeWarning(upgradeWarning);
                }
            } else {
                this.a.debug("not exist uncompatible ap, " + upgradeWarning);
                if (upgradeWarning.isShowUpgradeWarning() || upgradeWarning.isShowUpgradeIcon()) {
                    upgradeWarning.setShowUpgradeIcon(false);
                    upgradeWarning.setShowUpgradeWarning(false);
                    this.f.refreshUpgradeWarning(upgradeWarning);
                }
            }
            return upgradeWarning;
        }
    }
}

